<?php
header('Content-Type: text/html; charset=UTF-8');
session_start();
include 'db_connection.php'; // Ensure DB connection

// Retrieve session variables safely
$monitor_name = isset($_SESSION['monitor_name']) ? $_SESSION['monitor_name'] : '';  
$id = isset($_SESSION['id']) ? (int) $_SESSION['id'] : 0;  
$school_id = isset($_SESSION['SchoolID']) ? (int) $_SESSION['SchoolID'] : 0;  

// Debugging
if (empty($id) || empty($school_id) || empty($monitor_name)) {
    die("يجب ادخال البيانات الأساسية اولاُ");
}

// منع الوصول إذا تم إكمال تقييم المعلم الأول بالفعل
if (isset($_SESSION['teacher1_completed']) && $_SESSION['teacher1_completed']) {
    header("Location: index.php");
    exit();
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
 
  // Handling radio buttons and checkboxes safely
   
  $forms = is_array($_POST['forms']) ? implode(", ", $_POST['forms']) : $_POST['forms'];
  $sounds = is_array($_POST['sounds']) ? implode(", ", $_POST['sounds']) : $_POST['sounds'];
  $position = is_array($_POST['position']) ? implode(", ", $_POST['position']) : $_POST['position'];
  $words = is_array($_POST['words']) ? implode(", ", $_POST['words']) : $_POST['words'];
  $writing = is_array($_POST['writing']) ? implode(", ", $_POST['writing']) : $_POST['writing'];
  $formation = is_array($_POST['formation']) ? implode(", ", $_POST['formation']) : $_POST['formation'];
  $strategies = is_array($_POST['strategies']) ? implode(", ", $_POST['strategies']) : $_POST['strategies'];
  $games = is_array($_POST['games']) ? implode(", ", $_POST['games']) : $_POST['games'];
  $activities = is_array($_POST['activities']) ? implode(", ", $_POST['activities']) : $_POST['activities'];
  $tools = is_array($_POST['tools']) ? implode(", ", $_POST['tools']) : $_POST['tools'];
  $sounds_mastery_1A = is_array($_POST['sounds_mastery']) ? implode(", ", $_POST['sounds_mastery']) : $_POST['sounds_mastery'];
  $check1_1B = is_array($_POST['check1']) ? implode(", ", $_POST['check1']) : $_POST['check1'];
  $forms_mastery_2A =  $_POST['forms_mastery'];
  $strategies_other_Q1 = isset($_POST['strategyOther']) ? $_POST['strategyOther'] : '';
  $check2B = is_array($_POST['check2']) ? implode(", ", $_POST['check2']) : $_POST['check2'];
  
$forms_mastery_3A =  $_POST['forms_mastery3'];
$strategies_other_Q3 = isset($_POST['check3Other']) ? $_POST['check3Other'] : '';
$check3B = is_array($_POST['check3']) ? implode(", ", $_POST['check3']) : $_POST['check3'];

$forms_mastery_4A =  $_POST['forms_mastery4'];
$strategies_other_Q4 = isset($_POST['check4Other']) ? $_POST['check4Other'] : '';
$check4B = is_array($_POST['check4']) ? implode(", ", $_POST['check4']) : $_POST['check4'];
  
    $games_others_Q2 = isset($_POST['gameOther']) ? $_POST['gameOther'] : '';
    $activities_others_Q3 = isset($_POST['activityOther']) ? $_POST['activityOther'] : '';
    $toolsOther_Q4 = isset($_POST['toolOther']) ? $_POST['toolOther'] : '';
    $teacher_1 = isset($_POST['teacher_1']) ? $_POST['teacher_1'] : '';
    $check1Other_1B = isset($_POST['check1Other']) ? $_POST['check1Other'] : '';
    $check2Other_2B = isset($_POST['check2Other']) ? $_POST['check2Other'] : '';

    
    // Insert into database
    $query = "INSERT INTO quality_control (
      SchoolID, forms, sounds, position, words, writing, formation, 
      strategies, strategies_other_Q1, games, games_others_Q2, activities, activities_others_Q3, 
      tools, toolsOther_Q4, sounds_mastery_1A, check1_1B, check1Other_1B, 
      forms_mastery_2A, check2B, check2Other_2B, Rid, monitor_nameQC, teacher_1,`forms_mastery_3A`, `check3B`, `check3Other_B`, `forms_mastery_4A`, `check4B`, `check4Other_4B`
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?)";

    $stmt = $conn->prepare($query);
    if (!$stmt) {
        die("خطأ في إدخال البيانات: " . $conn->error);
    }

    $stmt->bind_param(
        "issssssssssssssssssssissssssss", 
        $school_id, $forms, $sounds, $position, $words, $writing, $formation, 
        $strategies, $strategies_other_Q1, $games, $games_others_Q2, $activities, $activities_others_Q3, 
        $tools, $toolsOther_Q4, $sounds_mastery_1A, $check1_1B, $check1Other_1B, 
        $forms_mastery_2A, $check2B, $check2Other_2B, $id, $monitor_name, $teacher_1, $forms_mastery_3A ,$check3B ,$strategies_other_Q3 , $forms_mastery_4A,
         $check4B ,$strategies_other_Q4  
    );

    // In register_program.php, after successful insertion
// في register_program.php، بعد الإدخال الناجح في قاعدة البيانات
if ($stmt->execute()) {
    $_SESSION['teacher1_completed'] = true;
    $_SESSION['show_choice_message'] = true; // تغيير هذا المتغير
    $_SESSION['message'] = "تم تسجيل نتائج تقييم معلم 1 بنجاح";
    header("Location: success.php"); // التوجيه إلى success.php أولاً
    exit();
}

    $stmt->close();
}

$schools = mysqli_query($conn, "SELECT * FROM schoolsdata");


?>
  
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>بيانات المعلم الاول </title>
  <link rel="stylesheet" href="style.css">
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.0/jquery.min.js"></script>

</head>

<body>
<div class="container">
<h1>البرنامج القومي لتنمية مهارات القراءة والكتابة بالحلقة الابتدائية
        <p>استمارة ضبط الجودة والدعم الفني (الاسبوع الحادى عشر )</p></h1>
    
  <form action="" method="post" >

        <div class="form-group">
         <label>أسم المعلم المستهدف بالزيارة الحالية:</label>
        <input type="text" name="teacher_1" placeholder="المعلم (1)" id="inputy" required>
        </div>
          
    <!-- المحور الثاني: الممارسات التدريسية -->
    <fieldset >
        
        <legend>المحور الثاني : الممارسات التدريسية</legend>
        <h3>هل قام/ يقوم المعلم بالممارسات التدريسية التالية:</h3>
        
        <div class="form-group">
          <label>- استنتاج معاني الكلمات من السياق:</label>
          <div class="radio-group">
            <label>
              <input type="radio" name="forms" value="نعم" required>
              <span>نعم</span>
            </label>
            <label>
              <input type="radio" name="forms" value="لا" required>
              <span>لا</span>
            </label>
          </div>
        </div>
        
        <div class="form-group">
          <label>- تحديد الفكر الرئيسية في النص المقروء:</label>
          <div class="radio-group">
            <label>
              <input type="radio" name="sounds" value="نعم" required>
              <span>نعم</span>
            </label>
            <label>
              <input type="radio" name="sounds" value="لا" required>
              <span>لا</span>
            </label>
          </div>
        </div>
        
        <div class="form-group">
          <label>- كتابة الجمل بخط النسخ كتابة صحيحة:</label>
          <div class="radio-group">
            <label>
              <input type="radio" name="words" value="نعم" required>
              <span>نعم</span>
            </label>
            <label>
              <input type="radio" name="words" value="لا" required>
              <span>لا</span>
            </label>
          </div>
        </div>
        
        <div class="form-group">
          <label>- التعبير عن الفكر والشعور بجمل بسيطة:</label>
          <div class="radio-group">
            <label>
              <input type="radio" name="writing" value="نعم" required>
              <span>نعم</span>
            </label>
            <label>
              <input type="radio" name="writing" value="لا" required>
              <span>لا</span>
            </label>
          </div>
        </div>
        
        <div class="form-group">
          <label>- قراءة جمل ونصوص قصيرة بطلاقة:</label>
          <div class="radio-group">
            <label>
              <input type="radio" name="formation" value="نعم" required>
              <span>نعم</span>
            </label>
            <label>
              <input type="radio" name="formation" value="لا" required>
              <span>لا</span>
            </label>
          </div>
        </div>
        
        <div class="form-group">
          <label>- اكتشاف الأخطاء في الكلمات وتصويبها:</label>
          <div class="radio-group">
            <label>
              <input type="radio" name="position" value="نعم" required>
              <span>نعم</span>
            </label>
            <label>
              <input type="radio" name="position" value="لا" required>
              <span>لا</span>
            </label>
          </div>
        </div>
      </fieldset>
        
      
      <!-- المحور الثالث: استراتيجيات التدريس والوسائل -->
      <fieldset >
        <legend>المحور الثالث: استراتيجيات التدريس والوسائل</legend>
        
        <h3>(1) ما الاستراتجيات التي يستخدمها المعلم أثناء التدريس (يمكنك اختيار أكثر من واحدة):</h3>
        <div class="form-group">
          <div class="checkbox-group">
            <label>
              <input type="checkbox" name="strategies[]" value="التعلم التعاوني">
              <span>التعلم التعاوني</span>
            </label>
            <label>
              <input type="checkbox" name="strategies[]" value="المحاكاة">
              <span>المحاكاة</span>
            </label>
            <label>
              <input type="checkbox" name="strategies[]" value="النمذجة">
              <span>النمذجة</span>
            </label>
            <label>
              <input type="checkbox" name="strategies[]" value="القصص المسلسلة">
              <span>القصص المسلسلة</span>
            </label>
            <label>
              <input type="checkbox" name="strategies[]" value="تتبع الحرف">
              <span>تتبع الحرف</span>
            </label>
            <label>
              <input type="checkbox" name="strategies[]" value="الوقوف المتكرر">
              <span>الوقوف المتكرر</span>
            </label>
            <label>
              <input type="checkbox" name="strategies[]" value="البحث عن الحرف">
              <span>البحث عن الحرف</span>
            </label>
          </div>
          <div class="form-group" style="margin-top: 1rem;">
            <label for="strategyOther">أخري: تذكر </label>
            <input type="text" id="strategyOther" name="strategyOther" placeholder="اكتب استراتيجية أخرى">
          </div>
        </div>
        
        <h3>(2) ما الألعاب اللغوية التي يستخدمها المعلم في التدريس (يمكنك اختيار أكثر من واحدة):</h3>
        <div class="form-group">
          <div class="checkbox-group">
            <label>
              <input type="checkbox" name="games[]" value="الأكواب المقلوبة">
              <span>الأكواب المقلوبة</span>
            </label>
            <label>
              <input type="checkbox" name="games[]" value="الكلمات المتقاطعة">
              <span>الكلمات المتقاطعة</span>
            </label>
            <label>
              <input type="checkbox" name="games[]" value="التصفيق للحرف">
              <span>التصفيق للحرف</span>
            </label>
            <label>
              <input type="checkbox" name="games[]" value="الفنان الصغير">
              <span>الفنان الصغير</span>
            </label>
            <label>
              <input type="checkbox" name="games[]" value="صندوق الحروف">
              <span>صندوق الحروف</span>
            </label>
            <label>
              <input type="checkbox" name="games[]" value="رفع الحل">
              <span>رفع الحل</span>
            </label>
            <label>
              <input type="checkbox" name="games[]" value="امرح مع الحرف">
              <span>امرح مع الحرف</span>
            </label>
          </div>
          <div class="form-group" style="margin-top: 1rem;">
            <label for="gameOther">أخري: تذكر </label>
            <input type="text" id="gameOther" name="gameOther" placeholder="اكتب لعبة لغوية أخرى">
          </div>
        </div>
        
        <h3>(3) ما الأنشطة التفاعلية التي يستخدمها المعلم في التدريس (يمكنك اختيار أكثر من واحدة):</h3>
        <div class="form-group">
          <div class="checkbox-group">
            <label>
              <input type="checkbox" name="activities[]" value="الرسم">
              <span>الرسم</span>
            </label>
            <label>
              <input type="checkbox" name="activities[]" value="الكتابة">
              <span>الكتابة</span>
            </label>
            <label>
              <input type="checkbox" name="activities[]" value="التلوين">
              <span>التلوين</span>
            </label>
            <label>
              <input type="checkbox" name="activities[]" value="اكتشاف الخطأ">
              <span>اكتشاف الخطأ</span>
            </label>
            <label>
              <input type="checkbox" name="activities[]" value="الترتيب">
              <span>الترتيب</span>
            </label>
            <label>
              <input type="checkbox" name="activities[]" value="الاستخراج">
              <span>الاستخراج</span>
            </label>
            <label>
              <input type="checkbox" name="activities[]" value="الإكمال">
              <span>الإكمال</span>
            </label>
          </div>
          <div class="form-group" style="margin-top: 1rem;">
            <label for="activityOther">أخري: تذكر </label>
            <input type="text" id="activityOther" name="activityOther" placeholder="اكتب نشاط تفاعلي آخر">
          </div>
        </div>
        
        <h3>(4) ما الوسائل التعليمية التي يستخدمها المعلم في التدريس (يمكنك اختيار أكثر من واحدة):</h3>
        <div class="form-group">
          <div class="checkbox-group">
            <label>
              <input type="checkbox" name="tools[]" value="السبورة">
              <span>السبورة</span>
            </label>
            <label>
              <input type="checkbox" name="tools[]" value="الأقلام الملونة">
              <span>الأقلام الملونة</span>
            </label>
            <label>
              <input type="checkbox" name="tools[]" value="الصور">
              <span>الصور</span>
            </label>
            <label>
              <input type="checkbox" name="tools[]" value="البطاقات">
              <span>البطاقات</span>
            </label>
            <label>
              <input type="checkbox" name="tools[]" value="الصحف">
              <span>الصحف</span>
            </label>
            <label>
              <input type="checkbox" name="tools[]" value="عجلة الكلمات">
              <span>عجلة الكلمات</span>
            </label>
            <label>
              <input type="checkbox" name="tools[]" value="مسرح العرائس">
              <span>مسرح العرائس</span>
            </label>
          </div>
          <div class="form-group" style="margin-top: 1rem;">
            <label for="toolOther">أخري: تذكر </label>
            <input type="text" id="toolOther" name="toolOther" placeholder="اكتب وسيلة تعليمية أخرى">
          </div>
        </div>
      </fieldset>
      
      <!-- المحور الرابع: مدى تقدم مستوى التلاميذ في البرنامج -->
      <fieldset >
        <legend>المحور الرابع : مدى تقدم مستوى التلاميذ في البرنامج</legend>
        
        <h3>(1-أ) ما مدى إتقان التلاميذ لمهارة استنتاج معاني الكلمات من السياق؟</h3>
        <div class="form-group">
          <div class="radio-group">
            <label>
              <input type="radio" name="sounds_mastery" value="جميع التلاميذ" required>
              <span>جميع التلاميذ</span>
            </label>
            <label>
              <input type="radio" name="sounds_mastery" value="معظم التلاميذ" required>
              <span>معظم التلاميذ</span>
            </label>
            <label>
              <input type="radio" name="sounds_mastery" value="بعض التلاميذ" required>
              <span>بعض التلاميذ</span>
            </label>
            <label>
              <input type="radio" name="sounds_mastery" value="لا احد من التلاميذ" required>
              <span>لا احد من التلاميذ</span>
            </label>
          </div>
        </div>
        
        <h3>(1-ب) ما وسيلة التحقق من مستوى إتقان التلاميذ لمهارة استنتاج معاني الكلمات من السياق؟</h3>
        <div class="form-group">
          <div class="checkbox-group">
            <label>
              <input type="checkbox" name="check1[]" value="اختبار قراءة">
              <span>اختبار قراءة</span>
            </label>
            <label>
              <input type="checkbox" name="check1[]" value="اختبار إملاء">
              <span>اختبار إملاء</span>
            </label>
            <label>
              <input type="checkbox" name="check1[]" value="مناقشة صفية">
              <span>مناقشة صفية</span>
            </label>
            <label>
              <input type="checkbox" name="check1[]" value="ملاحظة">
              <span>ملاحظة</span>
            </label>
          </div>
          <div class="form-group" style="margin-top: 1rem;">
            <label for="check1Other">أخري: تذكر </label>
            <input type="text" id="check1Other" name="check1Other" placeholder="اكتب وسيلة أخرى">
          </div>
        </div>
        
        <h3>(2-أ) ما مدى إتقان التلاميذ لمهارة تحديد الفكر الرئيسية في النص المقروء ؟</h3>
        <div class="form-group">
          <div class="radio-group">
            <label>
              <input type="radio" name="forms_mastery" value="جميع التلاميذ" required>
              <span>جميع التلاميذ</span>
            </label>
            <label>
              <input type="radio" name="forms_mastery" value="معظم التلاميذ" required>
              <span>معظم التلاميذ</span>
            </label>
            <label>
              <input type="radio" name="forms_mastery" value="بعض التلاميذ" required>
              <span>بعض التلاميذ</span>
            </label>
            <label>
              <input type="radio" name="forms_mastery" value="لا احد من التلاميذ" required>
              <span>لا احد من التلاميذ</span>
            </label>
          </div>
        </div>
        
        <h3>(2-ب) ما وسيلة التحقق من مستوى إتقان التلاميذ لمهارة تحديد الفكر الرئيسية في النص المقروء ؟</h3>
        <div class="form-group">
          <div class="checkbox-group">
            <label>
              <input type="checkbox" name="check2[]" value="اختبار قراءة">
              <span>اختبار قراءة</span>
            </label>
            <label>
              <input type="checkbox" name="check2[]" value="اختبار إملاء">
              <span>اختبار إملاء</span>
            </label>
            <label>
              <input type="checkbox" name="check2[]" value="مناقشة صفية">
              <span>مناقشة صفية</span>
            </label>
            <label>
              <input type="checkbox" name="check2[]" value="ملاحظة">
              <span>ملاحظة</span>
            </label>
          </div>
          <div class="form-group" style="margin-top: 1rem;">
            <label for="check2Other">أخري: تذكر </label>
            <input type="text" id="check2Other" name="check2Other" placeholder="اكتب وسيلة أخرى">
          </div>
        </div>

        <h3>(3-أ) ما مدى إتقان التلاميذ لمهارة كتابة جمل بخط النسخ؟</h3>
        <div class="form-group">
          <div class="radio-group">
            <label>
              <input type="radio" name="forms_mastery3" value="جميع التلاميذ" required>
              <span>جميع التلاميذ</span>
            </label>
            <label>
              <input type="radio" name="forms_mastery3" value="معظم التلاميذ" required>
              <span>معظم التلاميذ</span>
            </label>
            <label>
              <input type="radio" name="forms_mastery3" value="بعض التلاميذ" required>
              <span>بعض التلاميذ</span>
            </label>
            <label>
              <input type="radio" name="forms_mastery3" value="لا احد من التلاميذ" required>
              <span>لا احد من التلاميذ</span>
            </label>
          </div>
        </div>
        
        <h3>(3-ب) ما وسيلة التحقق من مستوى إتقان التلاميذ لمهارة كتابة جمل بخط النسخ؟</h3>
        <div class="form-group">
          <div class="checkbox-group">
            <label>
              <input type="checkbox" name="check3[]" value="اختبار قراءة">
              <span>اختبار قراءة</span>
            </label>
            <label>
              <input type="checkbox" name="check3[]" value="اختبار إملاء">
              <span>اختبار إملاء</span>
            </label>
            <label>
              <input type="checkbox" name="check3[]" value="مناقشة صفية">
              <span>مناقشة صفية</span>
            </label>
            <label>
              <input type="checkbox" name="check3[]" value="ملاحظة">
              <span>ملاحظة</span>
            </label>
          </div>
          <div class="form-group" style="margin-top: 1rem;">
            <label for="check3Other">أخري: تذكر </label>
            <input type="text" id="check3Other" name="check3Other" placeholder="اكتب وسيلة أخرى">
          </div>
        </div>
        
        <h3>(4-أ) ما مدى إتقان التلاميذ لمهارة التعبير عن الفكر والشعور بجمل بسيطة ؟</h3>
        <div class="form-group">
          <div class="radio-group">
            <label>
              <input type="radio" name="forms_mastery4" value="جميع التلاميذ" required>
              <span>جميع التلاميذ</span>
            </label>
            <label>
              <input type="radio" name="forms_mastery4" value="معظم التلاميذ" required>
              <span>معظم التلاميذ</span>
            </label>
            <label>
              <input type="radio" name="forms_mastery4" value="بعض التلاميذ" required>
              <span>بعض التلاميذ</span>
            </label>
            <label>
              <input type="radio" name="forms_mastery4" value="لا احد من التلاميذ" required>
              <span>لا احد من التلاميذ</span>
            </label>
          </div>
        </div>
        
        <h3>(4-ب) ما وسيلة التحقق من مستوى إتقان التلاميذ لمهارة التعبير عن الفكر والشعور بجمل بسيطة؟</h3>
        <div class="form-group">
          <div class="checkbox-group">
            <label>
              <input type="checkbox" name="check4[]" value="اختبار قراءة">
              <span>اختبار قراءة</span>
            </label>
            <label>
              <input type="checkbox" name="check4[]" value="اختبار إملاء">
              <span>اختبار إملاء</span>
            </label>
            <label>
              <input type="checkbox" name="check4[]" value="مناقشة صفية">
              <span>مناقشة صفية</span>
            </label>
            <label>
              <input type="checkbox" name="check4[]" value="ملاحظة">
              <span>ملاحظة</span>
            </label>
          </div>
          <div class="form-group" style="margin-top: 1rem;">
            <label for="check4Other">أخري: تذكر </label>
            <input type="text" id="check4Other" name="check4Other" placeholder="اكتب وسيلة أخرى">
          </div>
        </div>
      </fieldset>
      
      
      <div class="buttons-container">
        <button type="submit" class="submit-button">إرسال</button>
      </div>
      
    </form>   
</div>
</body>
</html>