<?php
session_start();
include 'db_connection.php';

if (isset($_SESSION['session_id'])) {
    $session_id = $_SESSION['session_id'];
    
    // Mark the session as partially completed (only teacher 1)
    $sql = "UPDATE quality_monitoring_data SET 
        teacher1_completed = TRUE,
        all_completed = FALSE
        WHERE session_id = ?";
    
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $session_id);
    
    if ($stmt->execute()) {
        // Set completion message without destroying session
        $_SESSION['completion_message'] = "تم حفظ البيانات الأساسية وتقييم المعلم الأول بنجاح! يمكنك البدء في تقييم جديد عندما تحتاج.";
        
        // Clear only evaluation flags, keep login session
        unset($_SESSION['teacher1_completed']);
        unset($_SESSION['teacher2_completed']);
        unset($_SESSION['show_choice_message']);
        
        header("Location: index.php");
        exit();
    }
} else {
    header("Location: index.php");
    exit();
}
?>