<?php
session_start();
header('Content-Type: text/html; charset=UTF-8');

// إضافة هذا الجزء للتعامل مع حالة إكمال المعلمين
if(isset($_SESSION['teacher1_completed'])) {
    $teacher1Status = 'مكتمل';
} else {
    $teacher1Status = 'في الانتظار';
}

if(isset($_SESSION['teacher2_completed'])) {
    $teacher2Status = 'مكتمل';
} else {
    $teacher2Status = 'في الانتظار';
}

// إذا تم إكمال المعلم الأول، عرض رسالة الاختيار في الصفحة الرئيسية
if (isset($_SESSION['teacher1_completed']) && $_SESSION['teacher1_completed'] && !isset($_SESSION['teacher2_completed'])) {
    $_SESSION['show_choice_message'] = true;
}
?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>تم بنجاح</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/meyer-reset/2.0/reset.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="logos.css">
    <style>
        :root {
            --primary-color: #2c3e50;
            --secondary-color: #3498db;
            --accent-color: #2980b9;
            --success-color: #27ae60;
            --warning-color: #f39c12;
            --danger-color: #e74c3c;
            --light-bg: #f8fafc;
            --text-color: #2d3748;
            --border-radius: 12px;
            --box-shadow: 0 8px 30px rgba(0, 0, 0, 0.08);
            --gradient-primary: linear-gradient(135deg, #3498db, #2980b9);
            --gradient-success: linear-gradient(135deg, #27ae60, #219653);
            --gradient-card: linear-gradient(135deg, #ffffff 0%, #f8fafc 100%);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Tajawal', sans-serif;
        }
        
        body {
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            direction: rtl;
            text-align: right;
            min-height: 100vh;
            color: var(--text-color);
            line-height: 1.6;
            overflow-x: hidden;
        }

        /* Main Container */
        .container {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: flex-start;
            min-height: 100vh;
            padding: 30px 20px;
            position: relative;
            overflow-x: hidden;
        }

        /* Professional Background Pattern */
        .container::before {
            content: "";
            position: fixed;
            top: 0;
            right: 0;
            width: 100%;
            height: 100%;
            background: 
                radial-gradient(circle at 20% 80%, rgba(52, 152, 219, 0.08) 0%, transparent 50%),
                radial-gradient(circle at 80% 20%, rgba(41, 128, 185, 0.08) 0%, transparent 50%),
                radial-gradient(circle at 40% 40%, rgba(39, 174, 96, 0.05) 0%, transparent 50%);
            z-index: -1;
        }

        /* Program Title */
        .program-title {
            font-size: 2rem;
            font-weight: 700;
            text-align: center;
            margin: 40px 0 40px;
            color: var(--primary-color);
            position: relative;
            padding: 25px 50px;
            max-width: 900px;
            line-height: 1.4;
            background: var(--gradient-card);
            backdrop-filter: blur(15px);
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
        }

        .program-title i {
            margin-left: 15px;
            color: var(--secondary-color);
        }

        .program-title::after {
            content: "";
            position: absolute;
            bottom: -8px;
            right: 50%;
            transform: translateX(50%);
            width: 120px;
            height: 3px;
            background: linear-gradient(to right, #3498db, #2ecc71);
            border-radius: 2px;
        }

        /* Success Container */
        .success-container {
            background: var(--gradient-card);
            backdrop-filter: blur(15px);
            padding: 3rem;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            text-align: center;
            max-width: 700px;
            width: 100%;
            margin: 0 auto;
            border: 1px solid rgba(255, 255, 255, 0.8);
        }
        
        .success-icon {
            width: 100px;
            height: 100px;
            background: var(--gradient-success);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 30px;
            color: white;
            font-size: 2.5rem;
            box-shadow: 0 10px 30px rgba(39, 174, 96, 0.4);
        }
        
        .success-title {
            color: var(--primary-color);
            margin-bottom: 20px;
            font-size: 2rem;
            font-weight: 700;
        }
        
        .success-message {
            color: #64748b;
            margin-bottom: 30px;
            font-size: 1.2rem;
            line-height: 1.6;
        }
        
        .btn {
            display: inline-block;
            background: var(--gradient-primary);
            color: white;
            padding: 15px 30px;
            text-decoration: none;
            border-radius: var(--border-radius);
            font-weight: 600;
            font-size: 1.1rem;
            transition: all 0.3s ease;
            box-shadow: 0 5px 20px rgba(52, 152, 219, 0.3);
            border: none;
            cursor: pointer;
            font-family: 'Tajawal', sans-serif;
        }
        
        .btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(52, 152, 219, 0.4);
        }
        
        .steps-info {
            background: rgba(52, 152, 219, 0.1);
            padding: 20px;
            border-radius: var(--border-radius);
            margin: 30px 0;
            text-align: right;
            border: 1px solid rgba(52, 152, 219, 0.2);
        }
        
        .steps-info h3 {
            color: var(--primary-color);
            margin-bottom: 15px;
            font-size: 1.3rem;
            font-weight: 700;
        }
        
        .steps-info ul {
            list-style: none;
            text-align: right;
        }
        
        .steps-info li {
            padding: 10px 0;
            color: #4a5568;
            display: flex;
            align-items: center;
            gap: 10px;
            font-size: 1.1rem;
        }
        
        .steps-info li i {
            color: var(--success-color);
            font-size: 1.2rem;
        }

        /* Choice Message Styling */
        .choice-message {
            background: #e3f2fd;
            color: #1565c0;
            padding: 20px;
            border-radius: var(--border-radius);
            margin: 20px 0;
            border: 2px solid #bbdefb;
            text-align: center;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }
        
        .choice-buttons {
            margin-top: 15px;
            display: flex;
            gap: 15px;
            justify-content: center;
            flex-wrap: wrap;
        }
        
        .choice-btn {
            padding: 12px 25px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-weight: bold;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-block;
            font-size: 14px;
        }
        
        .choice-btn.continue {
            background: var(--success-color);
            color: white;
        }
        
        .choice-btn.finish {
            background: var(--warning-color);
            color: white;
        }
        
        .choice-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.2);
        }

        /* Progress Tracker */
        .progress-tracker {
            display: flex;
            justify-content: space-between;
            align-items: center;
            width: 100%;
            max-width: 800px;
            margin: 30px 0 50px;
            position: relative;
            padding: 0 40px;
        }

        .progress-step {
            display: flex;
            flex-direction: column;
            align-items: center;
            position: relative;
            flex: 1;
            z-index: 2;
        }

        .progress-step:not(:last-child)::after {
            content: '';
            position: absolute;
            top: 25px;
            right: 60%;
            width: 100%;
            height: 3px;
            background: #e0e6ed;
            z-index: 1;
            transition: all 0.3s ease;
        }

        .progress-step.active:not(:last-child)::after,
        .progress-step.completed:not(:last-child)::after {
            background: var(--success-color);
            box-shadow: 0 0 10px rgba(39, 174, 96, 0.3);
        }

        .step-icon {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            background: #e0e6ed;
            color: #64748b;
            font-size: 1.2rem;
            position: relative;
            z-index: 2;
            transition: all 0.3s ease;
            border: 3px solid white;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            margin-bottom: 15px;
        }

        .progress-step.active .step-icon {
            background: var(--success-color);
            color: white;
            transform: scale(1.1);
            box-shadow: 0 6px 20px rgba(39, 174, 96, 0.4);
        }

        .progress-step.completed .step-icon {
            background: var(--success-color);
            color: white;
        }

        .progress-step.completed .step-icon i {
            transform: scale(1);
        }

        .progress-step span {
            color: #64748b;
            font-weight: 600;
            font-size: 0.9rem;
            text-align: center;
            background: transparent !important;
            padding: 0 !important;
            margin: 0 !important;
            transition: all 0.3s ease;
        }

        .progress-step.active span {
            color: var(--primary-color);
            font-weight: 700;
        }

        .progress-step.completed span {
            color: var(--success-color);
        }

        /* Responsive Design */
        @media (max-width: 992px) {
            .program-title {
                font-size: 1.6rem;
                padding: 20px 30px;
            }
            
            .success-container {
                padding: 2rem;
            }
        }

        @media (max-width: 768px) {
            .container {
                padding: 20px 15px;
            }
            
            .program-title {
                font-size: 1.3rem;
                margin: 20px 0 30px;
                padding: 15px 20px;
            }
            
            .progress-tracker {
                flex-direction: column;
                gap: 25px;
                padding: 0 20px;
                margin: 20px 0 40px;
            }
            
            .progress-step:not(:last-child)::after {
                display: none;
            }
            
            .success-container {
                padding: 1.5rem;
            }
            
            .choice-buttons {
                flex-direction: column;
                align-items: center;
            }
            
            .choice-btn {
                width: 100%;
                max-width: 250px;
            }
        }

        @media (max-width: 480px) {
            .container {
                padding: 15px 10px;
            }
            
            .program-title {
                font-size: 1.1rem;
                padding: 12px 15px;
            }
            
            .success-container {
                padding: 1rem;
            }
            
            .success-icon {
                width: 80px;
                height: 80px;
                font-size: 2rem;
            }
            
            .success-title {
                font-size: 1.5rem;
            }
            
            .success-message {
                font-size: 1rem;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Program Title Only - No Logos -->
        <div class="program-title">
            <i class="fas fa-graduation-cap"></i>
            البرنامج القومي لتنمية مهارات القراءة والكتابة بالحلقة الابتدائية
        </div>

        <!-- Progress Tracker -->
        <div class="progress-tracker">
            <div class="progress-step completed" data-step="1">
                <div class="step-icon"><i class="fas fa-school"></i></div>
                <span>البيانات الأساسية</span>
            </div>
            <div class="progress-step <?php echo (isset($_SESSION['teacher1_completed']) ? 'completed' : 'active'); ?>" data-step="2">
                <div class="step-icon"><i class="fas fa-chalkboard-teacher"></i></div>
                <span>تقييم المعلم الأول</span>
            </div>
            <div class="progress-step <?php echo (isset($_SESSION['teacher2_completed']) ? 'completed' : ''); ?>" data-step="3">
                <div class="step-icon"><i class="fas fa-chalkboard-teacher"></i></div>
                <span>تقييم المعلم الثاني</span>
            </div>
        </div>

        <div class="success-container">
            <div class="success-icon">
                <i class="fas fa-check"></i>
            </div>
            
            <h1 class="success-title">تمت العملية بنجاح!</h1>
            
            <?php if(isset($_SESSION['message'])): ?>
                <p class="success-message"><?php echo $_SESSION['message']; unset($_SESSION['message']); ?></p>
            <?php else: ?>
                <p class="success-message">تم حفظ البيانات بنجاح في النظام</p>
            <?php endif; ?>
            
            <!-- عرض رسالة الاختيار إذا تم إكمال المعلم الأول فقط -->
            <?php if (isset($_SESSION['teacher1_completed']) && $_SESSION['teacher1_completed'] && !isset($_SESSION['teacher2_completed'])): ?>
            <div class="choice-message">
                <i class="fas fa-question-circle" style="margin-left: 10px;"></i>
                تم إكمال تقييم المعلم الأول بنجاح! هل تريد متابعة تقييم المعلم الثاني أو الاكتفاء بالبيانات الحالية؟
                <div class="choice-buttons">
                    <a href="techer2.php" class="choice-btn continue">
                        <i class="fas fa-arrow-right"></i> متابعة تقييم المعلم الثاني
                    </a>
                    <a href="finalize.php?action=finish" class="choice-btn finish">
                        <i class="fas fa-check"></i> الاكتفاء بالبيانات الحالية
                    </a>
                </div>
            </div>
            <?php endif; ?>
            
            <div class="steps-info">
                <h3>حالة إكمال النماذج:</h3>
                <ul>
                    <li><i class="fas fa-check-circle"></i> البيانات الأساسية - مكتمل</li>
                    <li><i class="fas <?php echo (isset($_SESSION['teacher1_completed']) ? 'fa-check-circle' : 'fa-clock'); ?>"></i> تقييم المعلم 1 - <?php echo $teacher1Status; ?></li>
                    <li><i class="fas <?php echo (isset($_SESSION['teacher2_completed']) ? 'fa-check-circle' : 'fa-clock'); ?>"></i> تقييم المعلم 2 - <?php echo $teacher2Status; ?></li>
                </ul>
            </div>
            
            <a href="index.php" class="btn">
                <i class="fas fa-home" style="margin-left: 10px;"></i>
                العودة إلى الصفحة الرئيسية
            </a>
        </div>
    </div>

   <script>
    // Set flag to show welcome message on index page
    sessionStorage.setItem('showWelcome', 'true');
    
    <?php if(isset($_SESSION['teacher1_completed'])): ?>
        // Remove this line to prevent setting currentStep
        // localStorage.setItem("currentStep", "2");
    <?php elseif(isset($_SESSION['teacher2_completed'])): ?>
        // Remove this section too
        // localStorage.setItem("currentStep", "3");
    <?php else: ?>
        // Remove this as well
        // localStorage.setItem("currentStep", "1");
    <?php endif; ?>
</script>
</body>
</html>