<?php
session_start();
include 'db_connection.php';

// Check if teacher 2 is completed
if (!isset($_SESSION['session_id'])) {
    header("Location: schoolbasic.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>تم إكمال جميع التقييمات</title>
    <link rel="stylesheet" href="styles123.css">
    <style>
        .success-container {
            text-align: center;
            padding: 50px 20px;
        }
        
        .success-icon {
            font-size: 80px;
            color: #28a745;
            margin-bottom: 20px;
        }
        
        .btn-save-final {
            padding: 15px 40px;
            background: #28a745;
            color: white;
            border: none;
            border-radius: 5px;
            font-size: 18px;
            cursor: pointer;
            margin-top: 30px;
            transition: all 0.3s ease;
        }
        
        .btn-save-final:hover {
            background: #218838;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.2);
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="success-container">
            <div class="success-icon">✓</div>
            <h1>تم إكمال جميع التقييمات بنجاح!</h1>
            <p>يمكنك الآن حفظ جميع البيانات وإنهاء الجلسة</p>
            
            <form action="save_complete.php" method="post">
                <button type="submit" class="btn-save-final">حفظ جميع البيانات وإنهاء الجلسة</button>
            </form>
        </div>
    </div>
</body>
</html>