<?php
session_start();
header('Content-Type: text/html; charset=UTF-8');

// Check for login success message
$login_success = '';
if (isset($_SESSION['login_success'])) {
    $login_success = $_SESSION['login_success'];
    unset($_SESSION['login_success']);
}

// Check for completion message
$completion_message = '';
if (isset($_SESSION['completion_message'])) {
    $completion_message = $_SESSION['completion_message'];
    unset($_SESSION['completion_message']);
}

// Check for choice message after teacher1 completion
$show_choice_message = false;
if (isset($_SESSION['show_choice_message']) && $_SESSION['show_choice_message']) {
    $show_choice_message = true;
    unset($_SESSION['show_choice_message']);
}
?>
<!DOCTYPE html>
<html lang="ar">
<head>
  <meta charset="UTF-8">
  <title>نظام متابعة الجودة - الصفحة الرئيسية</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/meyer-reset/2.0/reset.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link rel="stylesheet" href="./logos.css">
  <style>
    .choice-message {
      background: #e3f2fd;
      color: #1565c0;
      padding: 20px;
      border-radius: 10px;
      margin: 20px auto;
      max-width: 700px;
      text-align: center;
      border: 2px solid #bbdefb;
      direction: rtl;
      box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }
    
    .choice-buttons {
      margin-top: 15px;
      display: flex;
      gap: 15px;
      justify-content: center;
      flex-wrap: wrap;
    }
    
    .choice-btn {
      padding: 12px 25px;
      border: none;
      border-radius: 8px;
      cursor: pointer;
      font-weight: bold;
      transition: all 0.3s ease;
      text-decoration: none;
      display: inline-block;
      font-size: 14px;
    }
    
    .choice-btn.continue {
      background: #4caf50;
      color: white;
    }
    
    .choice-btn.finish {
      background: #ff9800;
      color: white;
    }
    
    .choice-btn:hover {
      transform: translateY(-2px);
      box-shadow: 0 4px 8px rgba(0,0,0,0.2);
    }
  </style>
</head>
<body>
  <div class="container">
    <!-- Header with Logos -->
    <div class="logo-container">
      <div class="logo">
        <img src="R copy.png" alt="Left Logo">
      </div>
      <div class="logo">
        <img src="wezara.png" alt="Center Logo">
      </div>
      <div class="logo">
        <img src="Nceee.png" alt="Right Logo">
      </div>
    </div>

    <!-- Program Title -->
    <div class="program-title">
      <i class="fas fa-graduation-cap"></i>
      البرنامج القومي لتنمية مهارات القراءة والكتابة بالحلقة الابتدائية
    </div>

    <!-- Progress Tracker -->
    <div class="progress-tracker">
      <div class="progress-step active" data-step="1">
        <div class="step-icon"><i class="fas fa-school"></i></div>
        <span>البيانات الأساسية</span>
      </div>
      <div class="progress-step" data-step="2">
        <div class="step-icon"><i class="fas fa-chalkboard-teacher"></i></div>
        <span>تقييم المعلم الأول</span>
      </div>
      <div class="progress-step" data-step="3">
        <div class="step-icon"><i class="fas fa-chalkboard-teacher"></i></div>
        <span>تقييم المعلم الثاني</span>
      </div>
    </div>

    <!-- Choice Message after Teacher1 Completion -->
    <?php if ($show_choice_message): ?>
    <div class="choice-message">
      <i class="fas fa-question-circle" style="margin-left: 10px;"></i>
      تم إكمال تقييم المعلم الأول بنجاح! هل تريد متابعة تقييم المعلم الثاني أو الاكتفاء بالبيانات الحالية؟
      <div class="choice-buttons">
        <a href="techer2.php" class="choice-btn continue">
          <i class="fas fa-arrow-right"></i> متابعة تقييم المعلم الثاني
        </a>
        <a href="finalize.php?action=finish" class="choice-btn finish">
          <i class="fas fa-check"></i> الاكتفاء بالبيانات الحالية
        </a>
      </div>
    </div>
    <?php endif; ?>

    <!-- Completion Message -->
    <?php if (!empty($completion_message)): ?>
    <div class="completion-message" style="background: #d4edda; color: #155724; padding: 15px; border-radius: 8px; margin: 20px auto; max-width: 700px; text-align: center; border: 1px solid #c3e6cb; direction: rtl;">
      <i class="fas fa-check-circle" style="margin-left: 10px;"></i>
      <?php echo $completion_message; ?>
    </div>
    <?php endif; ?>

    <!-- Navigation Menu -->
   <!-- Navigation Menu -->
<nav class="menu">
    <a href="schoolbasic.php" id="basicData" class="nav-card">
        <div class="nav-icon">
            <i class="fas fa-school"></i>
        </div>
        <div class="nav-content">
            <h3>البيانات الأساسية</h3>
            <p>إدخال معلومات المدرسة والزيارة</p>
        </div>
        <div class="nav-status active"></div>
    </a>

    <a href="register_program.php" id="teacher1" class="nav-card <?php echo (isset($_SESSION['id']) && !isset($_SESSION['teacher1_completed']) && !isset($_SESSION['completion_message'])) ? '' : 'disabled'; ?>">
        <div class="nav-icon">
            <i class="fas fa-chalkboard-teacher"></i>
        </div>
        <div class="nav-content">
            <h3>تقييم أداء معلم 1</h3>
            <p>تقييم الممارسات التدريسية للمعلم الأول</p>
        </div>
        <div class="nav-status <?php echo (isset($_SESSION['teacher1_completed'])) ? 'active' : ''; ?>"></div>
    </a>

    <a href="techer2.php" id="teacher2" class="nav-card <?php echo (isset($_SESSION['teacher1_completed']) && !isset($_SESSION['teacher2_completed']) && !isset($_SESSION['completion_message'])) ? '' : 'disabled'; ?>">
        <div class="nav-icon">
            <i class="fas fa-chalkboard-teacher"></i>
        </div>
        <div class="nav-content">
            <h3>تقييم أداء معلم 2</h3>
            <p>تقييم الممارسات التدريسية للمعلم الثاني</p>
        </div>
        <div class="nav-status <?php echo (isset($_SESSION['teacher2_completed'])) ? 'active' : ''; ?>"></div>
    </a>
</nav>
    <!-- Session Info -->

  </div>

<script>
   document.addEventListener("DOMContentLoaded", function() {
    console.log('DOM loaded - checking navigation status');
    
    // Handle navigation clicks with proper validation
    document.getElementById('basicData').addEventListener('click', function(e) {
        console.log('Basic data clicked - always allowed');
        // Clear any stored step data
        localStorage.removeItem("currentStep");
    });

    document.getElementById('teacher1').addEventListener('click', function(e) {
        const hasSessionData = <?php echo isset($_SESSION['id']) ? 'true' : 'false'; ?>;
        const teacher1Completed = <?php echo isset($_SESSION['teacher1_completed']) ? 'true' : 'false'; ?>;
        const hasCompletionMessage = <?php echo isset($_SESSION['completion_message']) ? 'true' : 'false'; ?>;
        
        // Disable if evaluation completed or fresh session
        if (!hasSessionData || teacher1Completed || hasCompletionMessage) {
            e.preventDefault();
            showMessage('يجب إكمال البيانات الأساسية أولاً', 'warning');
            return;
        }
        console.log('Teacher 1 clicked - allowed');
        localStorage.setItem("currentStep", "1");
    });

    document.getElementById('teacher2').addEventListener('click', function(e) {
        const teacher1Completed = <?php echo isset($_SESSION['teacher1_completed']) ? 'true' : 'false'; ?>;
        const teacher2Completed = <?php echo isset($_SESSION['teacher2_completed']) ? 'true' : 'false'; ?>;
        const hasCompletionMessage = <?php echo isset($_SESSION['completion_message']) ? 'true' : 'false'; ?>;
        
        // Disable if teacher1 not completed or evaluation finished
        if (!teacher1Completed || teacher2Completed || hasCompletionMessage) {
            e.preventDefault();
            showMessage('يجب إكمال تقييم المعلم الأول أولاً', 'warning');
            return;
        }
        console.log('Teacher 2 clicked - allowed');
        localStorage.setItem("currentStep", "2");
    });

    // Rest of your JavaScript functions remain the same...
    function showMessage(message, type = 'info') {
        // ... existing code ...
    }

    // Check if coming from success page
    if (sessionStorage.getItem('showWelcome')) {
        showMessage('مرحباً بك في نظام متابعة الجودة!', 'success');
        sessionStorage.removeItem('showWelcome');
    }

    // Show completion message if exists
    <?php if (!empty($completion_message)): ?>
    showMessage('<?php echo $completion_message; ?>', 'success');
    <?php endif; ?>
});
</script>
</body>
</html>