<?php
session_start();
header('Content-Type: text/html; charset=UTF-8');

// Redirect to index if already logged in
if (isset($_SESSION['user_id']) && isset($_SESSION['user_name'])) {
    header("Location: index.php");
    exit();
}

// Include the database connection file
include 'db_connection.php';
// ... rest of the code remains the same
?>
<?php
session_start();
header('Content-Type: text/html; charset=UTF-8');

// Include the database connection file
include 'db_connection.php';

// Handle form submissions
$message = '';
$message_type = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['login'])) {
        // Login process
        $national_id = trim(mysqli_real_escape_string($conn, $_POST['national_id']));
        
        if (empty($national_id)) {
            $message = 'الرجاء إدخال الرقم القومي';
            $message_type = 'error';
        } elseif (!preg_match('/^\d{14}$/', $national_id)) {
            $message = 'الرقم القومي يجب أن يتكون من 14 رقمًا فقط';
            $message_type = 'error';
        } else {
            // Check if user exists
            $stmt = mysqli_prepare($conn, "SELECT * FROM login WHERE national_id = ?");
            mysqli_stmt_bind_param($stmt, "s", $national_id);
            mysqli_stmt_execute($stmt);
            $result = mysqli_stmt_get_result($stmt);
            
            if (mysqli_num_rows($result) > 0) {
                $user = mysqli_fetch_assoc($result);
                
                // User found - login successful
                $_SESSION['user_id'] = $user['ID'];
                $_SESSION['user_name'] = $user['name'];
                $_SESSION['user_national_id'] = $user['national_id'];
                $_SESSION['login_success'] = 'مرحباً ' . $user['name'] . '! تم تسجيل الدخول بنجاح.';
                
                mysqli_stmt_close($stmt);
                
                // Redirect to index page
                header('Location: index.php');
                exit();
            } else {
                $message = 'الرقم القومي غير مسجل. الرجاء إنشاء حساب جديد.';
                $message_type = 'error';
            }
            mysqli_stmt_close($stmt);
        }
        
    } elseif (isset($_POST['register'])) {
        // Registration process
        $national_id = trim(mysqli_real_escape_string($conn, $_POST['national_id']));
        $name = trim(mysqli_real_escape_string($conn, $_POST['name']));
        $job = trim(mysqli_real_escape_string($conn, $_POST['job']));
        $workplace = trim(mysqli_real_escape_string($conn, $_POST['workplace']));
        $mobile = trim(mysqli_real_escape_string($conn, $_POST['mobile']));
        
        // Validation
        $errors = [];
        
        // National ID validation
        if (empty($national_id)) {
            $errors[] = 'الرقم القومي مطلوب';
        } elseif (!preg_match('/^\d{14}$/', $national_id)) {
            $errors[] = 'الرقم القومي يجب أن يتكون من 14 رقمًا فقط';
        }
        
        // Name validation
        if (empty($name)) {
            $errors[] = 'الاسم الكامل مطلوب';
        } elseif (strlen($name) < 2) {
            $errors[] = 'الاسم الكامل يجب أن يكون على الأقل حرفين';
        }
        
        // Mobile validation (if provided)
        if (!empty($mobile) && !preg_match('/^(010|011|012|015)\d{8}$/', $mobile)) {
            $errors[] = 'رقم الهاتف يجب أن يبدأ بـ 010, 011, 012, أو 015 ويتكون من 11 رقمًا';
        }
        
        if (count($errors) > 0) {
            $message = implode('<br>', $errors);
            $message_type = 'error';
        } else {
            // Check if national ID already exists
            $check_stmt = mysqli_prepare($conn, "SELECT ID FROM login WHERE national_id = ?");
            mysqli_stmt_bind_param($check_stmt, "s", $national_id);
            mysqli_stmt_execute($check_stmt);
            $check_result = mysqli_stmt_get_result($check_stmt);
            
            if (mysqli_num_rows($check_result) > 0) {
                $message = 'الرقم القومي مسجل مسبقاً. الرجاء استخدام رقم قومي مختلف.';
                $message_type = 'error';
            } else {
                // Insert new user
                $insert_stmt = mysqli_prepare($conn, "INSERT INTO login (national_id, name, job, workplace, mobile) VALUES (?, ?, ?, ?, ?)");
                mysqli_stmt_bind_param($insert_stmt, "sssss", $national_id, $name, $job, $workplace, $mobile);
                
                if (mysqli_stmt_execute($insert_stmt)) {
                    $message = 'تم إنشاء الحساب بنجاح! يمكنك الآن تسجيل الدخول.';
                    $message_type = 'success';
                    
                    // Clear form data after successful registration
                    $_POST = array();
                } else {
                    $message = 'حدث خطأ أثناء إنشاء الحساب. الرجاء المحاولة مرة أخرى.';
                    $message_type = 'error';
                }
                mysqli_stmt_close($insert_stmt);
            }
            mysqli_stmt_close($check_stmt);
        }
    }
}
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>نظام متابعة الجودة - تسجيل الدخول</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="style.css">
    <style>
        /* Additional styles specific to login page */
        .login-container {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            padding: 30px 20px;
            position: relative;
            overflow-x: hidden;
        }
        
        .login-container::before {
            content: "";
            position: fixed;
            top: 0;
            right: 0;
            width: 100%;
            height: 100%;
            background: 
                radial-gradient(circle at 20% 80%, rgba(52, 152, 219, 0.08) 0%, transparent 50%),
                radial-gradient(circle at 80% 20%, rgba(41, 128, 185, 0.08) 0%, transparent 50%),
                radial-gradient(circle at 40% 40%, rgba(39, 174, 96, 0.05) 0%, transparent 50%);
            z-index: -1;
        }
        
        .login-card {
            background: white;
            padding: 2.5rem;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            margin-bottom: 2rem;
            width: 100%;
            max-width: 500px;
            margin-left: auto;
            margin-right: auto;
        }
        
        .login-header {
            display: flex;
            border-bottom: 1px solid #eee;
            margin-bottom: 1.5rem;
        }
        
        .login-header button {
            flex: 1;
            padding: 18px;
            border: none;
            background: none;
            font-size: 18px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            font-family: 'Tajawal', sans-serif;
        }
        
        .login-header button.active {
            background-color: var(--secondary-color);
            color: white;
            border-radius: var(--border-radius);
        }
        
        .form {
            display: none;
        }
        
        .form.active {
            display: block;
            animation: fadeIn 0.5s ease;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .form h2 {
            text-align: center;
            margin-bottom: 25px;
            color: var(--primary-color);
            font-family: 'Tajawal', sans-serif;
        }
        
        .input-group {
            margin-bottom: 20px;
            position: relative;
        }
        
        .input-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: var(--primary-color);
            font-family: 'Tajawal', sans-serif;
        }
        
        .input-group input {
            width: 100%;
            padding: 14px;
            border: 2px solid #e0e3e7;
            border-radius: var(--border-radius);
            font-size: 16px;
            transition: all 0.3s ease;
            background: #f8fafc;
            font-family: 'Tajawal', sans-serif;
        }
        
        .input-group input:focus {
            border-color: var(--secondary-color);
            outline: none;
            background: white;
            box-shadow: 0 0 0 3px rgba(52, 152, 219, 0.1);
        }
        
        .input-group input.error {
            border-color: #e74c3c;
            box-shadow: 0 0 0 3px rgba(231, 76, 60, 0.1);
        }
        
        .input-hint {
            font-size: 12px;
            color: #666;
            margin-top: 5px;
            display: block;
        }
        
        .submit-btn {
            width: 100%;
            padding: 15px;
            background: linear-gradient(135deg, var(--secondary-color), var(--accent-color));
            border: none;
            border-radius: var(--border-radius);
            color: white;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            margin-top: 10px;
            font-family: 'Tajawal', sans-serif;
        }
        
        .submit-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(52, 152, 219, 0.4);
        }
        
        .submit-btn:disabled {
            background: #bdc3c7;
            cursor: not-allowed;
            transform: none;
            box-shadow: none;
        }
        
        .message {
            text-align: center;
            margin-top: 20px;
            padding: 10px;
            border-radius: 5px;
            font-family: 'Tajawal', sans-serif;
            display: block;
        }
        
        .message.success {
            background-color: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        
        .message.error {
            background-color: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        
        .required::after {
            content: " *";
            color: #e74c3c;
        }
        
        @media (max-width: 500px) {
            .login-card {
                max-width: 100%;
                padding: 1.5rem;
            }
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-card">
            <div class="login-header">
                <button type="button" class="active" id="loginBtn">تسجيل الدخول</button>
                <button type="button" id="registerBtn">إنشاء حساب</button>
            </div>
            
            <div class="form-container">
                <!-- Display Messages -->
                <?php if (!empty($message)): ?>
                <div class="message <?php echo $message_type; ?>">
                    <?php echo $message; ?>
                </div>
                <?php endif; ?>
                
                <!-- Login Form -->
                <form class="form active" id="loginForm" method="POST" action="">
                    <h2>تسجيل الدخول إلى حسابك</h2>
                    <div class="input-group">
                        <label for="loginNationalId" class="required">الرقم القومي</label>
                        <input type="text" id="loginNationalId" name="national_id" required 
                               maxlength="14"
                               pattern="\d{14}"
                               title="الرقم القومي يجب أن يكون 14 رقمًا"
                               value="<?php echo isset($_POST['national_id']) && !isset($_POST['register']) ? htmlspecialchars($_POST['national_id']) : ''; ?>"
                               oninput="validateNationalId(this)">
                        <span class="input-hint">يجب أن يتكون من 14 رقمًا فقط</span>
                    </div>
                    <button type="submit" name="login" class="submit-btn">تسجيل الدخول</button>
                </form>
                
                <!-- Registration Form -->
                <form class="form" id="registerForm" method="POST" action="">
                    <h2>إنشاء حساب جديد</h2>
                    <div class="input-group">
                        <label for="regNationalId" class="required">الرقم القومي</label>
                        <input type="text" id="regNationalId" name="national_id" required
                               maxlength="14"
                               pattern="\d{14}"
                               title="الرقم القومي يجب أن يكون 14 رقمًا"
                               value="<?php echo isset($_POST['national_id']) && isset($_POST['register']) ? htmlspecialchars($_POST['national_id']) : ''; ?>"
                               oninput="validateNationalId(this)">
                        <span class="input-hint">يجب أن يتكون من 14 رقمًا فقط</span>
                    </div>
                    <div class="input-group">
                        <label for="regName" class="required">الاسم الكامل</label>
                        <input type="text" id="regName" name="name" required
                               minlength="2"
                               value="<?php echo isset($_POST['name']) ? htmlspecialchars($_POST['name']) : ''; ?>">
                        <span class="input-hint">يجب أن يكون على الأقل حرفين</span>
                    </div>
                    <div class="input-group">
                        <label for="regJob">الوظيفة</label>
                        <input type="text" id="regJob" name="job"
                               value="<?php echo isset($_POST['job']) ? htmlspecialchars($_POST['job']) : ''; ?>">
                    </div>
                    <div class="input-group">
                        <label for="regWorkplace">مكان العمل</label>
                        <input type="text" id="regWorkplace" name="workplace"
                               value="<?php echo isset($_POST['workplace']) ? htmlspecialchars($_POST['workplace']) : ''; ?>">
                    </div>
                    <div class="input-group">
                        <label for="regMobile">رقم الهاتف</label>
                        <input type="tel" id="regMobile" name="mobile"
                               maxlength="11"
                               pattern="(010|011|012|015)\d{8}"
                               title="يجب أن يبدأ الرقم بـ 010, 011, 012, أو 015 ويتكون من 11 رقمًا"
                               value="<?php echo isset($_POST['mobile']) ? htmlspecialchars($_POST['mobile']) : ''; ?>"
                               oninput="validateMobile(this)">
                        <span class="input-hint">يجب أن يبدأ بـ 010, 011, 012, أو 015 (11 رقمًا)</span>
                    </div>
                    <button type="submit" name="register" class="submit-btn">إنشاء حساب</button>
                </form>
            </div>
        </div>
    </div>

    <script>
        // Toggle between login and register forms
        document.getElementById('loginBtn').addEventListener('click', function() {
            document.getElementById('loginBtn').classList.add('active');
            document.getElementById('registerBtn').classList.remove('active');
            document.getElementById('loginForm').classList.add('active');
            document.getElementById('registerForm').classList.remove('active');
            
            // Clear any existing messages
            const messages = document.querySelectorAll('.message');
            messages.forEach(msg => msg.style.display = 'none');
        });
        
        document.getElementById('registerBtn').addEventListener('click', function() {
            document.getElementById('registerBtn').classList.add('active');
            document.getElementById('loginBtn').classList.remove('active');
            document.getElementById('registerForm').classList.add('active');
            document.getElementById('loginForm').classList.remove('active');
            
            // Clear any existing messages
            const messages = document.querySelectorAll('.message');
            messages.forEach(msg => msg.style.display = 'none');
        });
        
        // Validation functions
        function validateNationalId(input) {
            const value = input.value.replace(/\D/g, ''); // Remove non-digits
            input.value = value; // Update input with only digits
            
            if (value.length === 14) {
                input.classList.remove('error');
            } else {
                input.classList.add('error');
            }
        }
        
        function validateMobile(input) {
            const value = input.value.replace(/\D/g, ''); // Remove non-digits
            input.value = value; // Update input with only digits
            
            if (value.length === 0 || /^(010|011|012|015)\d{8}$/.test(value)) {
                input.classList.remove('error');
            } else {
                input.classList.add('error');
            }
        }
        
        // Real-time validation for all inputs
        document.addEventListener('DOMContentLoaded', function() {
            // Validate existing national ID inputs
            const nationalIdInputs = document.querySelectorAll('input[name="national_id"]');
            nationalIdInputs.forEach(input => {
                validateNationalId(input);
            });
            
            // Validate existing mobile input
            const mobileInput = document.getElementById('regMobile');
            if (mobileInput) {
                validateMobile(mobileInput);
            }
        });
        
        // Auto-switch to registration form if there's a registration error
        <?php if (isset($_POST['register']) && !empty($message) && $message_type == 'error'): ?>
        document.getElementById('registerBtn').click();
        <?php endif; ?>
        
        // Auto-switch to login form if there's a login error
        <?php if (isset($_POST['login']) && !empty($message) && $message_type == 'error'): ?>
        document.getElementById('loginBtn').click();
        <?php endif; ?>
    </script>
</body>
</html>