[file name]: schoolbasic.php
[file content begin]
<?php
header('Content-Type: text/html; charset=UTF-8');
session_start();

// منع الوصول إذا كانت هناك بيانات مكتملة بالفعل
if (isset($_SESSION['teacher1_completed']) && $_SESSION['teacher1_completed']) {
    $_SESSION['error_message'] = "لا يمكن تعديل البيانات الأساسية بعد إكمال تقييم المعلمين";
    header("Location: index.php");
    exit();
}

// Check for login success message
$login_success = '';
if (isset($_SESSION['login_success'])) {
    $login_success = $_SESSION['login_success'];
    unset($_SESSION['login_success']);
}

// الحصول على بيانات المستخدم من الجلسة
$user_name = isset($_SESSION['user_name']) ? $_SESSION['user_name'] : '';
$user_job = isset($_SESSION['user_job']) ? $_SESSION['user_job'] : '';
$user_workplace = isset($_SESSION['user_workplace']) ? $_SESSION['user_workplace'] : '';

include 'db_connection.php';
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>استمارة ضبط الجودة والدعم الفني</title>
    <link rel="stylesheet" href="style.css">
    <!-- Add this line in the head section after the existing stylesheet -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.0/jquery.min.js"></script>

    <script>
        $(document).ready(function () {
            // Fetch Edara based on selected GovID
            $("#GovID").change(function () {
                var govID = $(this).val();
                if (govID !== "") {
                    $.ajax({
                        url: "fetch_edara.php",
                        method: "POST",
                        data: { GovID: govID },
                        success: function (data) {
                            $("#EdaraID").html(data);
                            $("#schoolID").html('<option disabled selected value="">اختر اسم المدرسة</option>'); // Reset school dropdown
                        }
                    });
                } else {
                    $("#EdaraID").html('<option disabled selected value="">اختر الإدارة التعليمية</option>');
                    $("#schoolID").html('<option disabled selected value="">اختر اسم المدرسة</option>');
                }
            });

            // Fetch Schools based on selected EdaraID
            $("#EdaraID").change(function () {
                var edaraID = $(this).val();
                if (edaraID !== "") {
                    $.ajax({
                        url: "fetch_schools.php",
                        method: "POST",
                        data: { EdaraID: edaraID },
                        success: function (data) {
                            $("#schoolID").html(data);
                        }
                    });
                } else {
                    $("#schoolID").html('<option disabled selected value="">اختر اسم المدرسة</option>');
                }
            });
        });
    </script>
  
</head>
<body>
    <div class="container">
        <h1>البرنامج القومي لتنمية مهارات اللغة العربية بالحلقة الابتدائية </h1>
        <p>استمارة ضبط الجودة والدعم الفني (الأسبوع الأول في المتابعة  من 1 نوفمبر إلى 6 نوفمبر 2025)</p>
       
        <form action="submit.php" method="post"> 
        
            <!-- المحور الأول: البيانات الأساسية -->
            <fieldset class="form-group">
                <legend>المحور الأول: البيانات الأساسية</legend>
                
                <!-- (ب) بيانات المتابع - تم نقله إلى الأعلى -->
                <div class="section-title">
                    <i class="fas fa-user-tie" style="margin-left: 10px;"></i>
                    (ب) بيانات المتابع
                </div>
                <div class="form-div">
                    <div class="form-group">
                        <label>الاسم:</label>
                        <input type="text" name="monitor_name" value="<?php echo htmlspecialchars($user_name); ?>" readonly required>
                        <small style="color: #666;">(هذا الحقل معبأ تلقائياً من بيانات حسابك)</small>
                    </div>
                </div>

                <!-- (أ) بيانات المدرسة -->
                <div class="section-title">
                    <i class="fas fa-school" style="margin-left: 10px;"></i>
                    (أ) بيانات المدرسة
                </div>
                <div class="form-div">
                    <div class="form-group">
                        <label for="GovID">المحافظة</label>
                        <select id="GovID" name="GovID" class="form-control" required>
                            <option value="">اختر المديرية</option>
                            <?php 
                                $queryitem = "SELECT * FROM government ORDER BY GovName;";
                                $result = mysqli_query($conn, $queryitem);
                                if ($result->num_rows > 0) {
                                    while ($row = $result->fetch_assoc()) {
                                        echo '<option value="'.$row['GovID'].'">'.$row['GovName'].'</option>';
                                    }
                                } else {
                                    echo '<option value="">لا يوجد مديرية</option>';
                                }
                            ?>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="EdaraID">الإدارة التعليمية</label>
                        <select id="EdaraID" name="EdaraID" class="form-control" required>
                            <option disabled selected value>اختر الإدارة التعليمية</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="school">المدرسة</label>
                        <select id="schoolID" name="SchoolID" class="form-control" required>
                            <option disabled selected value>اختر اسم المدرسة</option>
                        </select>
                    </div>
                </div>
                
                <div class="form-div">
                    <div class="form-group">
                        <label>عدد التلاميذ الكلي المشاركين في البرنامج :</label>
                        <input type="number" name="students_in_program" required>
                    </div>
                    <div class="form-group">
                        <label>عدد التلاميذ المدمجين المشاركين في البرنامج </label>
                        <input type="number" name="egyptian_students" required>
                    </div>
                    <div class="form-group">
                        <label>عدد التلاميذ غير المصريين المشاركين في البرنامج :</label>
                        <input type="number" name="non_egyptian_students" required>
                    </div>
                </div>
                
                <div class="form-div">
                    <div class="form-group">
                        <label>عدد الفصول المشاركة في البرنامج :</label>
                        <input type="number" name="classes_in_program" required>
                    </div>
                    <div class="form-group">
                        <label>عدد المعلمين المشاركين في البرنامج</label>
                        <input type="number" name="teachers_in_program" required>
                    </div>
                </div>
                
                <label for="teaching_stat">وقت تدريس البرنامج في المدرسة:</label>
                <div class="form-div">
                    <div class="form-group">
                        من الساعة <input type="time" name="teaching_start" required>
                    </div>
                    <div class="form-group">
                        إلى الساعة <input type="time" name="teaching_end" required>
                    </div> 
                </div>
                
                <!-- تم نقل قسم (ب) بيانات المتابع إلى الأعلى -->
                
                <div class="section-title visit">
    <i class="fas fa-calendar-check" style="margin-left: 10px;"></i>
    (ج) بيانات الزيارة (الاسبوع الحادى عشر)
</div>
                <div class="form-div">
                    <div class="form-group">        
                        <label for="visitDay">يوم الزيارة:</label>
                        <select id="visitDay" name="visitDay" required>
                            <option value="">اختر اليوم</option>
                            <option value="الأحد">الأحد</option>
                            <option value="الإثنين">الإثنين</option>
                            <option value="الثلاثاء">الثلاثاء</option>
                            <option value="الأربعاء">الأربعاء</option>
                            <option value="الخميس">الخميس</option>
                            <option value="الجمعة">الجمعة</option>
                            <option value="السبت">السبت</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>تاريخ الزيارة:</label>
                        <input type="date" name="visit_date" id="visit_date" required>
                    </div>
                </div>

                <fieldset name="lastfield">
                    <div>
                        <label>حضور مدير المدرسة يوم الزيارة:</label>
                        <div class="radio-group">
                            <label><input type="radio" name="principal_attendance" value="حاضر" required> حاضر</label>
                            <label><input type="radio" name="principal_attendance" value="غائب" required> غائب</label>
                        </div>
                    </div>
                    
                    <div>
                        <label>حضور عامل المدرسة يوم الزيارة:</label>
                        <div class="radio-group">
                            <label><input type="radio" name="worker_attendance" value="حاضر" required> حاضر</label>
                            <label><input type="radio" name="worker_attendance" value="غائب" required> غائب</label>
                        </div>
                    </div>
                    <div class="form-div">
                    <div class="form-group">
                        <label>عدد التلاميذ المشاركين في البرنامج الحاضرين يوم الزيارة:</label>
                        <input type="number" name="present_students" required>
                    </div>
                     
                    <div class="form-group">
                        <label>عدد المعلمين المشاركين في البرنامج الحاضرين يوم الزيارة:</label>
                        <input type="number" name="present_teachers" required>
                    </div>
                              </div>
                    <div>
                        <label>هل يستخدم مدير المدرسة دفتر حضور وانصراف للعاملين بالبرنامج:</label>
                        <div class="radio-group">
                            <label><input type="radio" name="attendance_register" value="نعم" required> نعم</label>
                            <label><input type="radio" name="attendance_register" value="لا" required> لا</label>
                        </div>
                    </div>

                    <div>
                        <label>هل يستخدم مدير المدرسة دفتر الزيارات لفصول البرنامج:</label>
                        <div class="radio-group">
                            <label><input type="radio" name="visit_register" value="نعم" required> نعم</label>
                            <label><input type="radio" name="visit_register" value="لا" required> لا</label>
                        </div>
                    </div>

                    <div class="form-group">
                        <label>ما عدد الزيارات التي قام بها مدير المدرسة لفصول البرنامج:</label>
                        <input type="number" name="manger_vist" required>
                    </div>

                    <div>
                        <label>هل يستخدم معلمو البرنامج دفاتر التحضير:</label>
                        <div class="radio-group">
                            <label><input type="radio" name="lesson_plans" value="نعم" required> نعم</label>
                            <label><input type="radio" name="lesson_plans" value="لا" required> لا</label>
                        </div>
                    </div>

                    <div>
                        <label>هل يستخدم معلمو البرنامج دفاتر حضور وغياب التلاميذ:</label>
                        <div class="radio-group">
                            <label><input type="radio" name="student_attendance_register" value="نعم" required> نعم</label>
                            <label><input type="radio" name="student_attendance_register" value="لا" required> لا</label>
                        </div>
                    </div>
                </fieldset>   

                <div class="buttons-container">
                    <button type="submit" class="submit-button">إرسال</button>
                </div>
            </form>
        </div>

        <script>
            function validateForm() {
                const visitDateInput = document.getElementById("visit_date").value;
                const visitDayField = document.getElementById("visitDay");

                if (!visitDateInput) {
                    alert("يرجى اختيار تاريخ الزيارة.");
                    return false;
                }

                const visitDate = new Date(visitDateInput);
                const days = ["الأحد", "الإثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
                const expectedDay = days[visitDate.getDay()];

                if (visitDayField.value !== expectedDay) {
                    alert("⚠️ خطأ: يوم الزيارة لا يتطابق مع التاريخ المحدد! يجب أن يكون " + expectedDay);
                    visitDayField.value = expectedDay; // Auto-correct the selection
                    return false;
                }

                return true;
            }

            document.getElementById("visit_date").addEventListener("change", function() {
                const visitDate = new Date(this.value);
                const visitDayField = document.getElementById("visitDay");
                const days = ["الأحد", "الإثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
                const expectedDay = days[visitDate.getDay()];
                
                visitDayField.value = expectedDay; // Automatically select the correct day
            });
        </script>
    </div>
</body>
</html>
