<?php
session_start();
include 'db_connection.php';

// Check if teacher 1 is completed
if (!isset($_SESSION['session_id'])) {
    header("Location: schoolbasic.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>تم إكمال تقييم المعلم الأول</title>
    <link rel="stylesheet" href="styles123.css">
    <style>
        .success-container {
            text-align: center;
            padding: 50px 20px;
        }
        
        .success-icon {
            font-size: 80px;
            color: #28a745;
            margin-bottom: 20px;
        }
        
        .button-group {
            display: flex;
            justify-content: center;
            gap: 20px;
            margin-top: 30px;
            flex-wrap: wrap;
        }
        
        .btn {
            padding: 12px 30px;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            transition: all 0.3s ease;
        }
        
        .btn-save {
            background: #28a745;
            color: white;
        }
        
        .btn-continue {
            background: #007bff;
            color: white;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.2);
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="success-container">
            <div class="success-icon">✓</div>
            <h1>تم إكمال تقييم المعلم الأول بنجاح!</h1>
            <p>يمكنك الآن حفظ البيانات وإنهاء الجلسة أو متابعة تقييم المعلم الثاني</p>
            
            <div class="button-group">
                <form action="save_partial.php" method="post" style="display: inline;">
                    <button type="submit" class="btn btn-save">حفظ البيانات وإنهاء الجلسة</button>
                </form>
                
                <a href="techer2.php" class="btn btn-continue">متابعة تقييم المعلم الثاني</a>
            </div>
        </div>
    </div>
</body>
</html>