<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>تسجيل الدخول - نظام التقييم</title>
  <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&display=swap" rel="stylesheet">
  <style>
    /* Base Styles */
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }
    
    body {
      font-family: 'Tajawal', sans-serif;
      background-color: #f5f7fa;
      min-height: 100vh;
      display: flex;
      flex-direction: column;
      color: #2d3748;
    }
    
    /* Header Styles */
    .program-header {
      background: linear-gradient(135deg, #1a4b8c 0%, #2a75d8 100%);
      color: white;
      padding: 1rem 0;
      position: relative;
      border-bottom: 4px solid #f8d64e;
    }
    
    .header-content {
      display: flex;
      align-items: center;
      justify-content: space-between;
      max-width: 1200px;
      margin: 0 auto;
      width: 100%;
      padding: 0 2rem;
    }
    
    .logo-right, .logo-left {
      height: 70px;
      object-fit: contain;
      transition: transform 0.3s ease;
    }
    
    .title-container {
      flex-grow: 1;
      text-align: center;
      padding: 0 1rem;
    }
    
    .program-title {
      font-size: 1.5rem;
      font-weight: 700;
      margin-bottom: 0.5rem;
    }
    
    /* Main Content - Centered Login */
    .main-content {
      flex: 1;
      display: flex;
      justify-content: center;
      align-items: center;
      padding: 2rem;
    }
    
    .login-container {
      width: 100%;
      max-width: 450px;
    }
    
    .login-card {
      background: white;
      border-radius: 12px;
      box-shadow: 0 10px 25px rgba(0, 0, 0, 0.08);
      overflow: hidden;
    }
    
    .login-header {
      background: linear-gradient(135deg, #1a4b8c 0%, #2a75d8 100%);
      color: white;
      padding: 1.5rem;
      text-align: center;
      position: relative;
    }
    
    .login-header h2 {
      font-size: 1.5rem;
      font-weight: 700;
    }
    
    .login-body {
      padding: 2rem;
    }
    
    .form-group {
      margin-bottom: 1.5rem;
    }
    
    .form-group label {
      display: block;
      margin-bottom: 0.5rem;
      font-weight: 600;
    }
    
    .form-control {
      width: 100%;
      padding: 0.75rem 1rem;
      border: 1px solid #e2e8f0;
      border-radius: 8px;
      font-size: 1rem;
      transition: all 0.3s;
    }
    
    .form-control:focus {
      border-color: #4299e1;
      box-shadow: 0 0 0 3px rgba(66, 153, 225, 0.2);
      outline: none;
    }
    
    .btn {
      width: 100%;
      padding: 0.875rem;
      background: linear-gradient(135deg, #1a4b8c 0%, #2a75d8 100%);
      color: white;
      border: none;
      border-radius: 8px;
      font-size: 1rem;
      font-weight: 600;
      cursor: pointer;
      transition: all 0.3s;
    }
    
    .btn:hover {
      background: linear-gradient(135deg, #163d75 0%, #2264c2 100%);
    }
    
    .login-footer {
      text-align: center;
      padding: 1rem;
      border-top: 1px solid #edf2f7;
      margin-top: 1rem;
    }
    
    /* Responsive Design */
    @media (max-width: 768px) {
      .header-content {
        flex-direction: column;
        padding: 0 1rem;
      }
      
      .logo-right, .logo-left {
        height: 60px;
        margin: 0.5rem 0;
      }
      
      .program-title {
        font-size: 1.3rem;
      }
      
      .main-content {
        padding: 1rem;
      }
    }
  </style>
</head>
<body>
  <!-- Header Section -->
  <header class="program-header">
    <div class="header-content">
      <img src="wezara.png" alt="شعار الوزارة" class="logo-right">
      <div class="title-container">
        <h1 class="program-title">البرنامج القومي لتنمية مهارات اللغة العربية بالحلقة الابتدائية</h1>
      </div>
      <img src="week.png" alt="شعار البرنامج" class="logo-left">
    </div>
  </header>

  <!-- Centered Login Form -->
  <main class="main-content">
    <div class="login-container">
      <div class="login-card">
        <div class="login-header">
          <h2>تسجيل الدخول</h2>
        </div>
        
        <div class="login-body">
          <form action="new_login_process.php" method="POST">
            <div class="form-group">
              <label for="national_id">الرقم القومي</label>
              <input 
                type="text" 
                id="national_id" 
                name="national_id" 
                class="form-control" 
                maxlength="14" 
                pattern="\d{14}" 
                required
                placeholder="أدخل 14 رقمًا"
              >
            </div>
            
            <button type="submit" class="btn">دخول</button>
            
            <div class="login-footer">
              <a href="new_register.php">إنشاء حساب جديد</a>
            </div>
          </form>
        </div>
      </div>
    </div>
  </main>
</body>
</html>