<?php
header('Content-Type: text/html; charset=utf-8');
include('last_db_config.php'); // تأكدي من مسار ملف الاتصال بقاعدة البيانات

// استعلام للحصول على ملخص التقييمات الكلي
$summaryQuery = "
SELECT 
  SUM(CASE WHEN st.evaluated = 1 THEN 1 ELSE 0 END) AS total_evaluated,
  SUM(CASE WHEN st.evaluated = 0 THEN 1 ELSE 0 END) AS total_not_evaluated
FROM student st
";

$summaryResult = mysqli_query($conn, $summaryQuery);
$summaryData = mysqli_fetch_assoc($summaryResult);

// فلترة المحافظة والإدارة
$govFilter = isset($_GET['gov']) ? $_GET['gov'] : '';
$edaraFilter = isset($_GET['edara']) ? $_GET['edara'] : '';

$whereClauses = [];

if ($govFilter !== '') {
    $whereClauses[] = "g.GovID = '" . mysqli_real_escape_string($conn, $govFilter) . "'";
}
if ($edaraFilter !== '') {
    $whereClauses[] = "e.EdaraID = '" . mysqli_real_escape_string($conn, $edaraFilter) . "'";
}

$whereSQL = '';
if (count($whereClauses) > 0) {
    $whereSQL = 'WHERE ' . implode(' AND ', $whereClauses);
}

// الاستعلام الرئيسي (بدون الناجحين والراسبين والغائبين)
$query = "
SELECT 
  g.GovName AS المحافظة,
  e.EdaraName AS الإدارة,
  sc.SchoolName AS المدرسة,
  COUNT(st.StudentID) AS العدد_الفعلي_للطلاب,
  SUM(CASE WHEN st.evaluated = 1 THEN 1 ELSE 0 END) AS عدد_المقيمين,
  SUM(CASE WHEN st.evaluated = 0 THEN 1 ELSE 0 END) AS عدد_غير_المقيمين
FROM student st
LEFT JOIN testresult tr ON st.StudentID = tr.StudentID
JOIN school sc ON st.SchoolID = sc.SchoolID
JOIN edara e ON sc.EdaraID = e.EdaraID
JOIN government g ON e.GovID = g.GovID
$whereSQL
GROUP BY g.GovName, e.EdaraName, sc.SchoolName
ORDER BY g.GovName, e.EdaraName, sc.SchoolName
";

$result = mysqli_query($conn, $query);

if (!$result) {
    die("خطأ في استعلام قاعدة البيانات: " . mysqli_error($conn));
}

// جلب المحافظات
$govsQuery = "SELECT GovID, GovName FROM government ORDER BY GovName";
$govsResult = mysqli_query($conn, $govsQuery);

// جلب الإدارات حسب المحافظة المحددة
$edarasResult = null;
if ($govFilter !== '') {
    $edarasQuery = "SELECT EdaraID, EdaraName FROM edara WHERE GovID = '" . mysqli_real_escape_string($conn, $govFilter) . "' ORDER BY EdaraName";
    $edarasResult = mysqli_query($conn, $edarasQuery);
}
?>

<!DOCTYPE html>
<html dir="rtl" lang="ar">
<head>
<meta charset="UTF-8" />
<title>تقرير تقييم الطلاب</title>
<style>
    table {
        width: 100%;
        border-collapse: collapse;
        text-align: center;
        font-family: Arial, sans-serif;
    }
    th, td {
        border: 1px solid #333;
        padding: 8px;
    }
    th {
        background-color: #009879;
        color: white;
    }
    tbody tr:nth-child(even) {
        background-color: #f3f3f3;
    }
</style>
<script>
function onGovChange() {
    var govSelect = document.getElementById('gov');
    var selectedGov = govSelect.value;
    window.location.href = '?gov=' + selectedGov;
}
function onEdaraChange() {
    var govSelect = document.getElementById('gov');
    var edaraSelect = document.getElementById('edara');
    var selectedGov = govSelect.value;
    var selectedEdara = edaraSelect.value;
    window.location.href = '?gov=' + selectedGov + '&edara=' + selectedEdara;
}
</script>
</head>
<body>

<h2 style="text-align:center;">تقرير تقييم الطلاب لكل مدرسة</h2>

<div style="margin-bottom:20px; text-align:center;">
    <label>اختر المحافظة: </label>
    <select id="gov" name="gov" onchange="onGovChange()">
        <option value="">-- الكل --</option>
        <?php while ($gov = mysqli_fetch_assoc($govsResult)) : ?>
            <option value="<?= $gov['GovID'] ?>" <?= ($govFilter === $gov['GovID']) ? 'selected' : '' ?>><?= htmlspecialchars($gov['GovName']) ?></option>
        <?php endwhile; ?>
    </select>

    <label>اختر الإدارة: </label>
    <select id="edara" name="edara" onchange="onEdaraChange()">
        <option value="">-- الكل --</option>
        <?php if ($edarasResult) : ?>
            <?php while ($edara = mysqli_fetch_assoc($edarasResult)) : ?>
                <option value="<?= $edara['EdaraID'] ?>" <?= ($edaraFilter === $edara['EdaraID']) ? 'selected' : '' ?>><?= htmlspecialchars($edara['EdaraName']) ?></option>
            <?php endwhile; ?>
        <?php endif; ?>
    </select>
</div>

<div style="text-align:center; margin-bottom: 20px;">
    <strong>عدد الطلاب الذين تم تقييمهم (عبر جميع المحافظات): </strong><?= $summaryData['total_evaluated'] ?><br>
    <strong>عدد الطلاب الذين لم يتم تقييمهم (عبر جميع المحافظات): </strong><?= $summaryData['total_not_evaluated'] ?>
</div>

<table>
    <thead>
        <tr>
            <th>المحافظة</th>
            <th>الإدارة</th>
            <th>المدرسة</th>
            <th>العدد الفعلي للطلاب</th>
            <th>عدد الطلاب التي تم تقييمهم</th>
            <th>عدد الطلاب التي لم يتم تقييمهم</th>
        </tr>
    </thead>
    <tbody>
    <?php while ($row = mysqli_fetch_assoc($result)) : ?>
        <tr>
            <td><?= htmlspecialchars($row['المحافظة']) ?></td>
            <td><?= htmlspecialchars($row['الإدارة']) ?></td>
            <td><?= htmlspecialchars($row['المدرسة']) ?></td>
            <td><?= $row['العدد_الفعلي_للطلاب'] ?></td>
            <td><?= $row['عدد_المقيمين'] ?></td>
            <td><?= $row['عدد_غير_المقيمين'] ?></td>
        </tr>
    <?php endwhile; ?>
    </tbody>
</table>

</body>
</html>
