<?php
header("Content-Type: text/html; charset=UTF-8");
include('last_db_config.php'); // الاتصال بقاعدة البيانات
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>إبلاغ عن مشكلة</title>
  <style>
    body { font-family: Arial; padding: 30px; background: #f9f9f9; }
    label { font-weight: bold; display: block; margin-top: 15px; }
    select, textarea, input, button {
      width: 95%; padding: 10px; margin-top: 5px;
      font-size: 16px;
    }
    .form-container {
      max-width: 600px; margin: auto; background: white;
      padding: 20px; border-radius: 10px; box-shadow: 0 0 10px #ccc;
    }
    button {
      background: #0288d1; color: white;
      border: none; border-radius: 5px; cursor: pointer;
    }
    button:hover { background: #0277bd; }
    #resultMessage { margin-top: 20px; text-align: center; font-weight: bold; }
  </style>
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.0/jquery.min.js"></script>
</head>
<body>
  <div class="form-container">
  <center>  <h2>ملاحظات إبلاغ عن مشكلة</h2></center>
    <form method="POST" id="issueForm">
      <label for="gov">المحافظة</label>
      <select id="gov" name="gov_id" required>
        <option value="">اختر المحافظة</option>
        <?php
          $res = mysqli_query($conn, "SELECT GovID, GovName FROM government ORDER BY GovName");
          while ($row = mysqli_fetch_assoc($res)) {
            echo "<option value='{$row['GovID']}'>{$row['GovName']}</option>";
          }
        ?>
      </select>

      <label for="edara">الإدارة التعليمية</label>
      <select id="edara" name="edara_id" required>
        <option value="">اختر الإدارة</option>
      </select>

      <label for="school">المدرسة</label>
      <select id="school" name="school_id" required>
        <option value="">اختر المدرسة</option>
      </select>

      <label for="class">الصف</label>
      <select name="class" required>
        <option value="">اختر الصف</option>
        <option value="3">الثالث</option>
        <option value="4">الرابع</option>
        <option value="5">الخامس</option>
        <option value="6">السادس</option>
      </select>

      <label for="student_name">اسم الطالب (اختياري)</label>
      <input type="text" name="student_name">

      <label for="issue">وصف المشكلة</label>
      <textarea name="issue_description" rows="5" required></textarea>

      <button type="submit">إرسال البلاغ</button>
      <div id="resultMessage"></div>
    </form>
  </div>

  <script>
    $('#gov').change(function () {
      $.post('action copy.php', { GovID: $(this).val() }, function (data) {
        $('#edara').html(data);
        $('#school').html('<option value="">اختر المدرسة</option>');
      });
    });

    $('#edara').change(function () {
      $.post('action copy.php', { EdaraID: $(this).val() }, function (data) {
        $('#school').html(data);
      });
    });

    $('#issueForm').on('submit', function (e) {
      e.preventDefault();

      $.ajax({
        type: 'POST',
        url: 'save_issue.php',
        data: $(this).serialize(),
        success: function (response) {
          $('#resultMessage').html(response).css('color', response.includes("✅") ? 'green' : 'red');

          if (response.includes("✅")) {
            $('#issueForm')[0].reset(); // تفريغ النموذج
            $('#edara').html('<option value="">اختر الإدارة</option>');
            $('#school').html('<option value="">اختر المدرسة</option>');
          }
        },
        error: function () {
          $('#resultMessage').html("❌ حدث خطأ أثناء إرسال البلاغ.").css('color', 'red');
        }
      });
    });
  </script>
</body>
</html>
